{{ *****************************************************
   *  Example4.1    : For "ET-BASE PX32 V1.0           *
   *                                                   *
   *  File Name   : Ex4.1_Mouse_On_TV.spin             *
   *  Compiler    : Propeller V1.06                    *
   *  Create By   : Sittiphol Yooyod (www.ett.co.th)   *
   *  Last Update : 28/January/2007                    *
   *  Function    : Move Curser Mouse On TV            *
   *                                                   *                  
   *                                                   *
   ***************************************************** }}
                    

CON

  _clkmode = xtal1 + pll16x
  _xinfreq = 5_000_000
  _stack = ($3000 + $3000 + 100) >> 2   'accomodate display memory and stack

  x_tiles = 16
  y_tiles = 12

  paramcount = 14       
  bitmap_base = $2000
  display_base = $5000

  lines = 5
  thickness = 2

 

VAR

  long  mousex, mousey

  long  tv_status     '0/1/2 = off/visible/invisible           read-only
  long  tv_enable     '0/? = off/on                            write-only
  long  tv_pins       '%ppmmm = pins                           write-only
  long  tv_mode       '%ccinp = chroma,interlace,ntsc/pal,swap write-only
  long  tv_screen     'pointer to screen (words)               write-only
  long  tv_colors     'pointer to colors (longs)               write-only               
  long  tv_hc         'horizontal cells                        write-only
  long  tv_vc         'vertical cells                          write-only
  long  tv_hx         'horizontal cell expansion               write-only
  long  tv_vx         'vertical cell expansion                 write-only
  long  tv_ho         'horizontal offset                       write-only
  long  tv_vo         'vertical offset                         write-only
  long  tv_broadcast  'broadcast frequency (Hz)                write-only
  long  tv_auralcog   'aural fm cog                            write-only

  word  screen[x_tiles * y_tiles]
  long  colors[64]


OBJ

  tv    : "tv"
  gr    : "graphics"
  mouse : "mouse" 

PUB main | x, y, i,color1,color2,color3,click


 '----------- Start TV -----------
  longmove(@tv_status, @tvparams, paramcount)
  tv_screen := @screen
  tv_colors := @colors
  tv.start(@tv_status)

  '---------- Init colors -----------
  
  repeat i from $00 to $0F
        colors[i] := $074E0802   'keep Color:$07=white,$4E=Sky Blue,$08=Green,Back Ground $02= Black
  repeat i from $10 to $1F
        colors[i] := $077E5802   'keep Color:$07=white,$7E=Light Green ,$58=Red,Back Ground $02= Black
  repeat i from $20 to $2F
        colors[i] := $07EE9802   'keep Color:$07=white,$EE=Pink,$98=Blue,Back Ground $02= Black
 
  '------- Init tile screen ----------
  
  repeat x from 0 to tv_hc - 1
    repeat y from 0 to tv_vc - 1
      case y
        0..3 : i :=  x
        4..7 : i := $10 + x
        8..11: i := $20 + x
        other: i := 0

      screen[x + y * tv_hc] := i << 10 + display_base >> 6 + x * tv_vc + y

  '------ Start and setup graphics ---------
  gr.start
  gr.setup(16, 12, 0, 0, bitmap_base)
 
  '-------------- Start mouse --------------
  
  mouse.start(24, 25)
  mousex := 128      ''Set Position Mouse X,Y: Display On TV
  mousey := 95  

  color1 := 3        ''Set Color Text 3 = white 
  color2 := 3
  color3 := 3
  

  repeat

    gr.clear                   ''Clear Screen


  '-------- Display Text "ETT DEMO MOUSE" -------
   
    gr.textmode(2,2,6,5)       ''Set Text Size 
    gr.colorwidth(color1,2)    ''Set Pixel Color and Width=2 (Pixel Circle)
    gr.text(130,160,@str0)      

    gr.textmode(2,2,6,5)       ''Set Text Size 
    gr.colorwidth(color2,18)   ''Set Pixel Color and Width=18 (Pixel rectang)
    gr.text(130,95,@str0)

    gr.textmode(2,2,6,5)       ''Set Text Size 
    gr.colorwidth(color3,2)    ''Set Pixel Color and Width=2 (Pixel Circle)
    gr.text(130,30,@str0)       


  '--------- Draw mouse pointe --------
     
    gr.width(1) 
    mousex := mousex + mouse.delta_x #> 0 <# 245     ''Update Position Mouse x
    mousey := mousey + mouse.delta_y #> 10 <# 190    ''Update Position Mouse y
    gr.pix(mousex,mousey,0,@arrow_mouse)             ''Plot Arrow Mouse


    click := mouse.buttons                           ''Read Mouse Button 

    if click == 1                                    ''Click Left
       if mousey < 63                                ''Check Limit Mouse
         color3 := 1
       if mousey < 127 and mousey > 62
         color2 := 1
       if mousey > 126
         color1 := 1

         
    elseif click == 2                                ''Click Right
       if mousey < 63                                ''Check Limit Mouse 
         color3 := 2
       if mousey < 127 and mousey > 62
         color2 := 2
       if mousey > 126
         color1 := 2
   
    else                                             ''No Click Mouse
       color1 := 3
       color2 := 3
       color3 := 3

    gr.copy(display_base)                            ''Copy bitmap to display  
  
   

DAT

tvparams                long    0               'status
                        long    1               'enable
                        long    %001_0101       'pins
                        long    %0000           'mode
                        long    0               'screen
                        long    0               'colors
                        long    x_tiles         'hc
                        long    y_tiles         'vc
                        long    10              'hx
                        long    1               'vx
                        long    0               'ho
                        long    0               'vo
                        long    60_000_000      'broadcast
                        long    0               'auralcog


                                   
arrow_mouse
                        word                  'arrow pointer 
                        byte    1,5,0,4       'size:x=1,y=5,Position original x=0,y=4
                        word    %%11110000
                        word    %%11100000
                        word    %%11110000
                        word    %%10111000
                        word    %%00011000
                        
str0                    byte  "**_ETT DEMO MOUSE_**",0